
void calibrate(void);



#include "HardwareProfile.h"
extern int Previous_Event;
extern int Cur_Event;
extern char LCDText[];
extern unsigned long Long_Int_A;
extern unsigned long Long_Int_B;
extern unsigned long Long_Int_C;
extern int sample;
extern unsigned long get_three;
extern int int_event;
extern unsigned int Int_A;
extern unsigned int Int_B;
extern unsigned int Int_C;
extern void Put_Three_Reg( unsigned int ,unsigned long  );
extern unsigned long Get_Three_Reg( unsigned int  );


void calibrate()
{

while(1)
{
		asm("CLRWDT");	// Clear the WatchDog Timer

	if(BUTTON1_IO == 0)
	{
		while (BUTTON1_IO == 0);
		delay_usec(20);
		while (BUTTON1_IO == 0);
		Cur_Event = Previous_Event+1;
    	Previous_Event++;
	}
		


switch( Cur_Event )
    	{
        	case 0:
            
             	break;
			case 1:
		 		Cur_Event =0;
           		sprintf(LCDText,"VRMSOS Test set 100v");
				LcdPrintString((BYTE *)LCDText);
				break;
        	case 2:
         		if (sample ==0)
        		{
	        		Put_Three_Reg(0x18,0x000200);  // start interrupt
	        		get_three = Get_Three_Reg(0x1a);	
        			int_event=2;
        			sample++;
        			Cur_Event=0;
        			break;
        		}
        		if (sample > 0 && sample < 11) 
        		{
	        		Long_Int_C = Long_Int_C +  Get_Three_Reg(0x0f);
	        		Long_Int_B = Long_Int_B +  Get_Three_Reg(0x0e);
	        		Long_Int_A = Long_Int_A +  Get_Three_Reg(0x0d);
	        		Cur_Event=0;
	        		sample++;
	        	  
	        	}
           		else
           		{
	           		Put_Three_Reg(0x18,0x000000);  // stop interrupt
	            	sprintf(LCDText,"A=%06lx B=%06lx",(Long_Int_A/10),(Long_Int_B/10));
					LcdPrintString((BYTE *)LCDText);
					sprintf(LCDText,"C= %06lx S=%d",(Long_Int_C/10),sample);
					LcdPrintString((BYTE *)LCDText);
					Cur_Event=0;
           			Long_Int_A =0;
           			Long_Int_B =0;
           			Long_Int_C =0;
           			sample = 0;
           			int_event = 0;
           			Previous_Event = 2;
           	
           		}
			 break;
        	case 3:
        	
        	Cur_Event =0;
           	sprintf(LCDText,"VRMSOS Test set 130v");
			LcdPrintString((BYTE *)LCDText);
            break;

        	case 4:
        
        		if (sample ==0)
        		{
	        		Put_Three_Reg(0x18,0x000200);  // start interrupt
	        		get_three = Get_Three_Reg(0x1a);	
        			int_event=4;
        			sample++;
        			Cur_Event=0; // need interrupt to get back 
        			break;
        		}
        
        
        
        		if (sample > 0 && sample < 11) 
        		{
	        	//	a_vrms[sample] = Get_Three_Reg(0x0d);
	        	//	b_vrms[sample] = Get_Three_Reg(0x0e);
	        	//	c_vrms[sample] = Get_Three_Reg(0x0f);
	        		Long_Int_A = Long_Int_A +  Get_Three_Reg(0x0d);
	        		Long_Int_B = Long_Int_B +  Get_Three_Reg(0x0e);
	        		Long_Int_C = Long_Int_C +  Get_Three_Reg(0x0f);
	        		sample++;
	        		Cur_Event=0;  // need interrupt to get back 
	        	}
           		else
           		{
	           		Put_Three_Reg(0x18,0x000000);  // stop interrupt
	            	sprintf(LCDText,"A= %06lx B= %06lx",(Long_Int_A/10),(Long_Int_B/10));
					LcdPrintString((BYTE *)LCDText);
					sprintf(LCDText,"C= %06lx S=%d",(Long_Int_C)/10,sample);
					LcdPrintString((BYTE *)LCDText);
					Cur_Event=0;
           			Long_Int_A =0;
           			Long_Int_B =0;
           			Long_Int_C =0;
           			sample = 0;
           			int_event = 0;
           			Previous_Event = 4;
           		}
			 	break;
        	case 5:
        	
           		Cur_Event =0;
           		sprintf(LCDText,"IRMSOS Test set MIN");
				LcdPrintString((BYTE *)LCDText);
            	break;
			case 6:
        		if (sample ==0)
        		{
	        		Put_Three_Reg(0x18,0x000200);  // start interrupt
	        		get_three = Get_Three_Reg(0x1a);	
        			int_event=6;
        			sample++;
        			Cur_Event=0;
        			break;
        		}
        
        
        
        		if (sample > 0 && sample < 11) 
        		{
	        	
	        		Long_Int_A = Long_Int_A +  Get_Three_Reg(0x0A);
	        		Long_Int_B = Long_Int_B +  Get_Three_Reg(0x0B);
	        		Long_Int_C = Long_Int_C +  Get_Three_Reg(0x0C);
	        		sample++;
	        		Cur_Event=0;  // need interrupt to get back 
	        	}
           		else
           		{
	           		Put_Three_Reg(0x18,0x000000);  // stop interrupt
	            	sprintf(LCDText,"A=%06lx B=%06lx",(Long_Int_A/10),(Long_Int_B/10));
					LcdPrintString((BYTE *)LCDText);
					sprintf(LCDText,"C= %06lx S=%d",(Long_Int_C/10),sample);
					LcdPrintString((BYTE *)LCDText);
					Cur_Event=0;
           			Long_Int_A =0;
           			Long_Int_B =0;
           			Long_Int_C =0;
           			sample = 0;
           			int_event = 0;
           			Previous_Event = 6;
           		}
			 	break;
       		case 7:
        	
           		Cur_Event =0;
           		sprintf(LCDText,"IRMSOS Test set TEST");
				LcdPrintString((BYTE *)LCDText);
            	break;
			case 8:
        		if (sample ==0)
        		{
	        		Put_Three_Reg(0x18,0x000200);  // start interrupt
	        		get_three = Get_Three_Reg(0x1a);	
        			int_event=8;
        			sample++;
        			Cur_Event=0;
        			break;
        
        		}
        
        		if (sample > 0 && sample < 11) 
        		{
	        	
	        		Long_Int_A = Long_Int_A +  Get_Three_Reg(0x0A);
	        		Long_Int_B = Long_Int_B +  Get_Three_Reg(0x0B);
	        		Long_Int_C = Long_Int_C +  Get_Three_Reg(0x0C);
	        		sample++;
	        		Cur_Event=0;  
	        	}
           		else
           		{
	           		Put_Three_Reg(0x18,0x000000);  // stop interrupt
	           		get_three = Get_Three_Reg(0x1a); // clear all interrupts
	            	sprintf(LCDText,"A=%06lx B=%06lx",(Long_Int_A/10),(Long_Int_B/10));
					LcdPrintString((BYTE *)LCDText);
					sprintf(LCDText,"C= %06lx S=%d",(Long_Int_C/10),sample);
					LcdPrintString((BYTE *)LCDText);
					Cur_Event=0;
           			Long_Int_A =0;
           			Long_Int_B =0;
           			Long_Int_C =0;
           			sample = 0;
           			int_event = 0;
           			Previous_Event = 8;
           		}
			 		break;
       		
       		case 9:
       		
           		sprintf(LCDText,"WATT GAIN SET 5 AMPS");
				LcdPrintString((BYTE *)LCDText);
				Cur_Event =0;
				sample = 0;
		    	break;
     
       		case 10:
       			Cur_Event =0;	
       			if (sample ==0)
       			{	
	       			Put_Two_Reg(0x17,0x8f00); // SET LINE CYCLE TO ACCUMULATION MODE
					Put_Two_Reg(0x1C,0x0258); // SET TO 5 SEC ACCUM
       				Put_Three_Reg(0x18,0x001000); // set line accum interrupt	
					get_three = Get_Three_Reg(0x1a); // clear all interrupts
					Cur_Event =0;  
					sample++;
					int_event=10;
					break;
				}
       			else
       			{		
	       			Put_Three_Reg(0x18,0x00000); // remove line accum interrupt	
	       			Int_A = Get_Two_Reg(0x01);
	       			Int_B = Get_Two_Reg(0x02);
	        		Int_C = Get_Two_Reg(0x03);
	      			sprintf(LCDText,"A=%04x B=%04x",Int_A,Int_B);
					LcdPrintString((BYTE *)LCDText);
					sprintf(LCDText,"C= %04x",Int_C);
					LcdPrintString((BYTE *)LCDText);
					sample = 0;
           			int_event = 0;
           			Previous_Event = 10;
           			Cur_Event=0;
           			Int_A =0;
           			Int_B =0;
           			Int_C =0;
					break;
       			}
       		case 11:
       			Cur_Event =0;
           		sprintf(LCDText,"VA SET TO 5 AMPS");
				LcdPrintString((BYTE *)LCDText);
				sample = 0;
		    	break;
    	
       		case 12:
       			Cur_Event =0;	
       			if (sample ==0)
       			{	
	       			Put_Two_Reg(0x17,0x8f00); // SET LINE CYCLE TO ACCUMULATION MODE
					Put_Two_Reg(0x1C,0x0258); // SET TO 5 SEC ACCUM
					
       				Put_Three_Reg(0x18,0x001000); // set line accum interrupt	
					get_three = Get_Three_Reg(0x1a); // clear all interrupts
					Cur_Event =0;  
					sample++;
					int_event=12;
					break;
				}
       			else
       			{		
	       			Put_Three_Reg(0x18,0x00000); // remove line accum interrupt	
	       			Int_A = Get_Two_Reg(0x07);
	       			Int_B = Get_Two_Reg(0x08);
	        		Int_C = Get_Two_Reg(0x09);
	      			sprintf(LCDText,"A=%04x B=%04x",Int_A,Int_B);
					LcdPrintString((BYTE *)LCDText);
					sprintf(LCDText,"C= %04x",Int_C);
					LcdPrintString((BYTE *)LCDText);
					sample = 0;
           			int_event = 0;
           			Previous_Event = 12;
           			Cur_Event=0;
           			Int_A =0;
           			Int_B =0;
           			Int_C =0;
         
		     
		       	
					break;
       			}
       			
       			
       		case 13:
       			Cur_Event =0;
           		sprintf(LCDText,"WATT OS SET .05AMPS");
				LcdPrintString((BYTE *)LCDText);
				sample = 0;
		    	break;
    	
       		case 14:
       			Cur_Event =0;	
       			if (sample ==0)
       			{	
	       			Put_Two_Reg(0x17,0x8f00); // SET LINE CYCLE TO ACCUMULATION MODE
					Put_Two_Reg(0x1C,0x0258); // SET TO 5 SEC ACCUM
					Put_Three_Reg(0x18,0x001000); // set line accum interrupt	
					get_three = Get_Three_Reg(0x1a); // clear all interrupts
					Cur_Event =0;  
					sample++;
					int_event=14;
					break;
				}
       			else
       			{		
	       			Put_Three_Reg(0x18,0x00000); // remove line accum interrupt	
	       			Int_A = Get_Two_Reg(0x01);
	       			Int_B = Get_Two_Reg(0x02);
	        		Int_C = Get_Two_Reg(0x03);
	      			sprintf(LCDText,"A=%04x B=%04x",Int_A,Int_B);
					LcdPrintString((BYTE *)LCDText);
					sprintf(LCDText,"C= %04x",Int_C);
					LcdPrintString((BYTE *)LCDText);
					sample = 0;
           			int_event = 0;
           			Previous_Event = 14;
           			Put_Two_Reg(0x17,0x7800); // CLEAR LINE CYCLE ACCUMULATION MODE
		     		Cur_Event=0;
           			Int_A =0;
           			Int_B =0;
           			Int_C =0;
         
		       	
					break;
       			}	
       		case 15:
       			Cur_Event =0;
           		sprintf(LCDText,"WATT OS SET 10AMPS");
				LcdPrintString((BYTE *)LCDText);
				sample = 0;
		    	break;
    	
       		case 16:
       			Cur_Event =0;	
       			if (sample ==0)
       			{	
	       			Put_Two_Reg(0x17,0x8f00); // SET LINE CYCLE TO ACCUMULATION MODE
					Put_Two_Reg(0x1C,0x0258); // SET TO 5 SEC ACCUM
					Put_Three_Reg(0x18,0x001000); // set line accum interrupt	
					get_three = Get_Three_Reg(0x1a); // clear all interrupts
					Cur_Event =0;  
					sample++;
					int_event=16;
					break;
				}
       			else
       			{		
	       			Put_Three_Reg(0x18,0x00000); // remove line accum interrupt	
	       			Int_A = Get_Two_Reg(0x01);
	       			Int_B = Get_Two_Reg(0x02);
	        		Int_C = Get_Two_Reg(0x03);
	      			sprintf(LCDText,"A=%04x B=%04x",Int_A,Int_B);
					LcdPrintString((BYTE *)LCDText);
					sprintf(LCDText,"C= %04x",Int_C);
					LcdPrintString((BYTE *)LCDText);
					sample = 0;
           			int_event = 0;
           			Previous_Event = 16;
           			Put_Two_Reg(0x17,0x7800); // CLEAR LINE CYCLE ACCUMULATION MODE
		     		Cur_Event =0;  
		       		Int_A =0;
           			Int_B =0;
           			Int_C =0;
					break;
       			}	
       			
       				
    default:
        	Cur_Event =0;
        	Previous_Event=0 ;
       		sprintf(LCDText,"%dDefault",Cur_Event);
			LcdPrintString((BYTE *)LCDText);
            break;
    }
}

}	